/*:
 * @target MZ
 * @plugindesc 一時的にマップ名の表示を制御できるプラグイン（完全非表示対応）
 * @author ruke
 *
 * @command DisableMapName
 * @text マップ名表示を無効化
 * @desc 一時的にマップ名の表示をOFFにします。
 *
 * @command EnableMapName
 * @text マップ名表示を有効化
 * @desc マップ名の表示を再び有効にします。
 */

(() => {
  let suppressMapName = false;

  PluginManager.registerCommand("HideMapName", "DisableMapName", () => {
    suppressMapName = true;

    const scene = SceneManager._scene;
    if (scene instanceof Scene_Map && scene._mapNameWindow) {
      const win = scene._mapNameWindow;
      win.close();
      win.visible = false;
      win.opacity = 0;
    }
  });

  PluginManager.registerCommand("HideMapName", "EnableMapName", () => {
    suppressMapName = false;
  });

  const _Scene_Map_createMapNameWindow = Scene_Map.prototype.createMapNameWindow;
  Scene_Map.prototype.createMapNameWindow = function () {
    _Scene_Map_createMapNameWindow.call(this);
    if (suppressMapName && this._mapNameWindow) {
      const win = this._mapNameWindow;
      win.close();
      win.visible = false;
      win.opacity = 0;
    }
  };

  const _Window_MapName_update = Window_MapName.prototype.update;
  Window_MapName.prototype.update = function () {
    if (suppressMapName) {
      this.close();
      this.visible = false;
      this.opacity = 0;
      return;
    }
    _Window_MapName_update.call(this);
  };

  const _Window_MapName_open = Window_MapName.prototype.open;
  Window_MapName.prototype.open = function () {
    if (suppressMapName) {
      return;
    }
    _Window_MapName_open.call(this);
  };
})();
